#region References

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;

#endregion

namespace gov.va.med.vbecs.GUI.controls
{


		#region Header
/*
		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/22/2003</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>This is the enhanced datagrid that is used for VBECS.</summary>
*/
		#endregion

	/// <summary>
	/// GridDirection
	/// </summary>
	public enum GridDirection
	{
		/// <summary>
		/// Up
		/// </summary>
		Up,
		/// <summary>
		/// Down
		/// </summary>
		Down,
		/// <summary>
		/// Left
		/// </summary>
		Left,
		/// <summary>
		/// Right
		/// </summary>
		Right
	}

	/// <summary>
	/// NextCellEventHandler
	/// </summary>
	public delegate void NextCellEventHandler();

	/// <summary>
	/// VbecsDataGrid
	/// </summary>
	public class VbecsDataGrid : DataGrid
	{ 
		private System.ComponentModel.Container components = null;

		private int hitCol; 
		private int hitRow; 
		private int _toolTipColumn = -1;
		private int _rightMostColumn = -1;
		private System.Windows.Forms.ToolTip toolTip1;
		private const int WM_LBUTTONDOWN = 513; // 0x0201 
		private const int WM_LBUTTONUP = 514;	// 0x0202 
		private const int WM_KEYDOWN = 256;		//0x100;
		private const int WM_KEYUP = 257;		//0x101;
		private bool _enterKeyPressed = false;	//CR 2792 this flag will be set to true if Enter key was pressed
		private bool _onMouseDownFired = false; //CR 2792 this flag is used to prevent from OnMouseDown event from firing multiple times
		private bool _gridEntered = false;		//CR 2792 this flag is used to prevent TextChagned event from firing when grid gets focus
		//
		
		/// <summary>
		/// NextCellEventHandler Event
		/// </summary>
		public event NextCellEventHandler NextCell;
		
		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/11/2003</CreationDate>
		/// <summary>
		///  Vbecs datagrid constructor.
		/// </summary>
		public VbecsDataGrid() 
		{ 
			hitCol = 0;
			hitRow = -1;

			this.toolTip1 = new System.Windows.Forms.ToolTip(); 
			this.toolTip1.InitialDelay = 250; 

			InitializeComponent();
		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			((System.ComponentModel.ISupportInitialize)(this)).BeginInit();
			// 
			// VbecsDataGrid
			// 
			this.AllowSorting = false;
			this.Anchor = (((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right);
			this.CaptionFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.CaptionVisible = false;
			this.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.HeaderFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.RowHeadersVisible = false;
			this.Size = new System.Drawing.Size(760, 356);
			((System.ComponentModel.ISupportInitialize)(this)).EndInit();

		}
		#endregion

		#region Properties

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/20/2003</CreationDate>
		/// <summary>
		///  Gets or sets the column where the tool tip resides.
		/// </summary>
		public int ToolTipColumn
		{
			get
			{
				return _toolTipColumn;
			}
			set 
			{
				_toolTipColumn = value;
			}
		}

		/// <summary>
		/// Get/Set RightMostColumn
		/// </summary>
		public int RightMostColumn
		{
			get
			{
				if(this._rightMostColumn==-1)
				{
					this._rightMostColumn=this.VisibleColumnCount;
				}
				return _rightMostColumn;
			}
			set
			{
				this._rightMostColumn=value; 
			}
		}

		/// <summary>
		/// CR 2792
		/// </summary>
		public bool EnterKeyPressed
		{
			get
			{
				return this._enterKeyPressed;
			}
		}

		/// <summary>
		/// CR 2792
		/// </summary>
		public bool GridEntered
		{
			get
			{
				return this._gridEntered;
			}

			set
			{
				this._gridEntered = value;
			}
		}

		#endregion

		#region Methods 
 
		/// <summary>
		/// SendMessage
		/// </summary>
		/// <param name="hWnd"></param>
		/// <param name="msg"></param>
		/// <param name="wParam"></param>
		/// <param name="lParam"></param>
		/// <returns></returns>
		[System.Runtime.InteropServices.DllImport("user32.dll")] 
		static extern bool SendMessage(IntPtr hWnd, Int32 msg, Int32 wParam, Int32 lParam); 

		/// <summary>
		/// SetNoCurrentCell
		/// </summary>
		public void SetNoCurrentCell() 
		{ 
			//click on top left corner of the grid 
			SendMessage( this.Handle, WM_LBUTTONDOWN, 0, 0); 
			SendMessage( this.Handle, WM_LBUTTONUP, 0, 0); 
		} 

		/// <summary>
		/// SetCurrentCell
		/// </summary>
		/// <param name="row"></param>
		/// <param name="col"></param>
		public void SetCurrentCell(int row, int col)
		{
			this.Focus();
			this.CurrentCell = new DataGridCell(row,col);
			this.OnCurrentCellChanged(EventArgs.Empty);
		}

		#endregion

		#region Events

		/// <summary>
		/// Invoke next cell event
		/// </summary>
		protected virtual void OnNextCell()
		{
			if (NextCell != null)
				NextCell();
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/13/2002</CreationDate>
		///
		/// <summary>
		/// This code prevents the sizing cursor from appearing in the datagrid.  It also 
		/// sets the tool tip for a row.
		/// </summary>
		/// <param name="e"></param>
		protected override void OnMouseMove(MouseEventArgs e)  
		{
			try
			{
				DataGrid.HitTestInfo hti = this.HitTest(new Point(e.X, e.Y)); 
				if(hti.Type == DataGrid.HitTestType.ColumnResize) 
				{ 
					return;
				} 
				else
				{
					if(hti.Type == DataGrid.HitTestType.Cell)
					{
						//If someone doesn't like the way this is behaving now, this is what I changed
						//Added this if check to set the tooltip, because it wasn't refreshing consistantly
						if (hti.Row > -1)
						{
							if (ToolTipColumn != -1)
								this.toolTip1.SetToolTip(this, this[hti.Row, ToolTipColumn].ToString()); 
						}
						if ( hti.Row != hitRow)
						{
							if (hti.Column == hitCol)
							{	
								if (ToolTipColumn != -1)
								{
									hitRow = hti.Row; 

									if(this.toolTip1 != null && this.toolTip1.Active) 
									{
										this.toolTip1.Active = false; 
									}

								    var toolTip = this.toolTip1;
                                    //CR 3554
								    if (toolTip != null) toolTip.Active = true;

								    return;
								}
							}
						}
					}
				}
				base.OnMouseMove(e); 
			}
			catch (System.ObjectDisposedException)
			{
				//swallow the ObjectDisposedException ocurring on a lock expiration
			}
		}

		/// <summary>
		/// CR 2792
		/// </summary>
		/// <param name="e"></param>
		protected override void OnEnter(EventArgs e)
		{
			this._gridEntered = true;
			base.OnEnter (e);
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/13/2002</CreationDate>
		///
		/// <summary>
		/// This code prevents allowing the user to resize the datagrid columns. 
		/// </summary>
		/// <param name="e"></param>
		protected override void OnMouseDown(MouseEventArgs e) 
		{
			//this code prevents OnMouseDown even from being fired multiple times on one mouse click
			//CR 2792
			if (_onMouseDownFired)
			{
				return;
			}
			
			try
			{
				DataGrid.HitTestInfo hti = this.HitTest(new Point(e.X, e.Y)); 
				DataGridCell currentCell = this.CurrentCell;
				//CR 2792 if the user clicks on anything else besides the grid cell the event will be skipped and the cursor placed back on the cell
				if(hti.Type != DataGrid.HitTestType.Cell) 
				{ 
					//setting flag to stop TextChanged event from firing when forcing cursor back into the grid
					this._enterKeyPressed = true;

					this.CurrentCell = new DataGridCell(0,0);
					this.CurrentCell = new DataGridCell(currentCell.RowNumber, currentCell.ColumnNumber);

					this._enterKeyPressed = false;
					return;
				}
				//clicking mouse button on a cell in a different row causes the TextChanged event to be fired
				//setting a flag to prevent this from happening CR 2792
				this._enterKeyPressed = true;
				_onMouseDownFired = true;

				base.OnMouseDown(e); 
				
				this._enterKeyPressed = false;
				_onMouseDownFired = false;
			}
			catch (System.ObjectDisposedException)
			{
				//swallow the ObjectDisposedException ocurring on a lock expiration
			}
		} 

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/13/2002</CreationDate>
		///
		/// <summary>
		/// This code makes the enter key act like the tab key.
		/// </summary>
		/// <param name="msg"></param>
		/// <param name="keyData"></param>
		/// <returns></returns>
		protected override bool ProcessCmdKey(ref Message msg, Keys keyData) 
		{
			try
			{
				if (msg.WParam.ToInt32() == (int)Keys.Return)
				{
					//CR 2792
					this._enterKeyPressed = true;
					this.OnNextCell();
					return(true);
				}
				else if (msg.WParam.ToInt32() == (int)Keys.Tab)
				{
					//CR 2792
					this._enterKeyPressed = false;
					this.InvokeLostFocus(this,new VbecsGridEventArgs(true));				
					return true;
				}
				//
			}
			catch (System.ObjectDisposedException)
			{
				//swallow the ObjectDisposedException ocurring on a lock expiration
			}

			//CR 2792
			this._enterKeyPressed = false;
			return base.ProcessCmdKey(ref msg, keyData);
		}  

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/11/2003</CreationDate>
		///
		/// <summary>
		/// This surpresses the tab key when processing a datagrid from top to bottom.
		/// </summary>
		/// <param name="msg"></param>
		/// <returns></returns>
		protected override bool ProcessKeyPreview(ref Message msg)
		{	
			try
			{
				if (msg.Msg == WM_KEYDOWN)
				{
					//If we're in a combo-box, Up and Down should navigate the list, not the grid
					if (((this.TableStyles[0].GridColumnStyles[this.CurrentCell.ColumnNumber].GetType().FullName == typeof(DataGridTextBoxColumn).FullName) ||
						(this.TableStyles[0].GridColumnStyles[this.CurrentCell.ColumnNumber].GetType().FullName == typeof(DataGridKeyTrapTextBoxColumn).FullName)) && 
						(((DataGridTextBoxColumn)this.TableStyles[0].GridColumnStyles[this.CurrentCell.ColumnNumber]).TextBox.Controls.Count>0))
					{
						if ((msg.WParam.ToInt32()==(int)Keys.Up)||(msg.WParam.ToInt32()==(int)Keys.Down))
						{
							return false;
						}
						//
						if (msg.WParam.ToInt32()==(int)Keys.Return)
						{
							OnNextCell();
							return true;
						}
						else if (msg.WParam.ToInt32()==(int)Keys.PageUp)
						{
							OnNextCell();
							return true;
						}
					}
				}
				//
				if (msg.Msg == WM_KEYUP)
				{
				}
				//
				if (this[this.CurrentCell] == DBNull.Value)
				{
					//
				}
			}
			catch (System.ObjectDisposedException)
			{
				//swallow the ObjectDisposedException ocurring on a lock expiration
			}
			//
			return base.ProcessKeyPreview(ref msg);
		}

		#endregion

	}

	/// <summary>
	/// Class VbecsGridEventArgs
	/// </summary>
	public class VbecsGridEventArgs : EventArgs
	{
		private bool _tabKeyPressed;

		/// <summary>
		/// VbecsGridEventArgs
		/// </summary>
		/// <param name="tabKeyPressed"></param>
		public VbecsGridEventArgs(bool tabKeyPressed)
		{
			this._tabKeyPressed = tabKeyPressed;
		}

		/// <summary>
		/// TabKeyPressed
		/// </summary>
		public bool TabKeyPressed
		{
			get
			{
				return this._tabKeyPressed;
			}
		}
	}

}



